/*******************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 *******************************************************************************

   Last Modification:
    @version $Id: S3M_NRT_Functionlist.h 37175 2013-08-08 09:44:48Z Sven $

  Changes:

      Version    Date         Author    Description
      ---------------------------------------------------------------------------

*******************************************************************************/

#ifndef __S3M_NRT_FUNCTIONLIST_H_
#define __S3M_NRT_FUNCTIONLIST_H_

/*************************************************************************************/
/** @name Prototypes
 *
 * The following prototypes are declared to represent
 * - the entry point of task
 * - the exit point of task to delete only the task resources (exit)
 * - the exit point of task to force a friendly shutdown (leave)
 * @{
 */
/* compatibility define */
#define TaskEnter_SERCOSIIIMasterNRT TaskEnter_S3M_NRT

void
TaskEnter_S3M_NRT(
    void * pvInit);

/** @} */


/*************************************************************************************/
/** @name Task Version
 *
 * Subsequently the version of task is defined.
 */

/** version of task startup parameter */
#define SERCOSIIIMASTER_NRT_STARTUP_PARAM_VERSION (1)


#ifndef TLR_TASK_SERCOSIIIMASTER_NRT
#define TLR_TASK_SERCOSIIIMASTER_NRT     ((TLR_TASKIDENTIFIER)0x00790000L)
#endif

/*************************************************************************************/
/** @name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 * @{
 */

/** task startup parameter */
typedef struct SERCOSIIIMASTER_NRT_STARTUPPARAMETER_Ttag  SERCOSIIIMASTER_NRT_STARTUPPARAMETER_T;


/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */
struct SERCOSIIIMASTER_NRT_STARTUPPARAMETER_Ttag    /* task startup parameter */
{
  TLR_TASK_PARAMETERHEADER;

  TLR_STR                         abEddName[16];
  TLR_UINT32                      ulEddInstance;
  TLR_BOOLEAN32                   fRsrcControl;
  TLR_BOOLEAN32                   fEnablePromiscModeAsDefault;
};

typedef SERCOSIIIMASTER_NRT_STARTUPPARAMETER_T S3M_NRT_STARTUPPARAMETER_T;

/** @} */


/*************************************************************************************/


#endif // __S3M_NRT_FUNCTIONLIST_H_
